/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api;

import com.google.common.collect.ImmutableList;
import io.github.lukebemish.dynamic_asset_generator.platform.Services;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;

public class ServerPrePackRepository {
    private static List<PackResources> resources = new ArrayList<PackResources>();

    public static void loadResources(List<PackResources> r) {
        resources = (List)r.stream().filter(p -> !p.m_8017_().contains("dynamic_asset_generator:client") && !p.m_8017_().contains("dynamic_asset_generator:data")).collect(ImmutableList.toImmutableList());
    }

    public static InputStream getResource(ResourceLocation rl) throws IOException {
        InputStream resource = null;
        for (PackResources r : resources) {
            if (r.m_8017_().equals("dynamic_asset_generator:data") || !r.m_7211_(PackType.SERVER_DATA, rl)) continue;
            if (resource != null) {
                resource.close();
            }
            resource = r.m_8031_(PackType.SERVER_DATA, rl);
        }
        if (resource != null) {
            return resource;
        }
        throw new IOException("Could not find data in pre-load: " + rl.toString());
    }

    public static List<InputStream> getResources(ResourceLocation rl) throws IOException {
        ArrayList<InputStream> out = new ArrayList<InputStream>();
        for (PackResources packResources : Services.DEGROUPER.unpackPacks(resources)) {
            if (packResources.m_8017_().equals("dynamic_asset_generator:data") || !packResources.m_7211_(PackType.SERVER_DATA, rl)) continue;
            out.add(0, packResources.m_8031_(PackType.SERVER_DATA, rl));
        }
        if (out.size() != 0) {
            return out;
        }
        throw new IOException("Could not find data in pre-load: " + rl.toString());
    }
}

